/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.dialogs;

import com.aptana.core.CoreStrings;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.WorkspaceConnectionPoint;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.dialogs.Messages;
import com.aptana.ui.IPropertyDialog;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.dialogs.FileFolderSelectionDialog;

public class WorkspaceConnectionPropertyDialog
extends TitleAreaDialog
implements IPropertyDialog {
    private static final String DEFAULT_NAME = Messages.WorkspaceConnectionPropertyDialog_NewShortcut;
    private WorkspaceConnectionPoint workspaceConnectionPoint;
    private boolean isNew = false;
    private Text nameText;
    private Text workspacePathText;
    private Button browseButton;
    private Image titleImage;
    private ModifyListener modifyListener;

    public WorkspaceConnectionPropertyDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setPropertySource(Object element) {
        this.workspaceConnectionPoint = null;
        if (element instanceof WorkspaceConnectionPoint) {
            this.workspaceConnectionPoint = (WorkspaceConnectionPoint)element;
        }
    }

    public Object getPropertySource() {
        return this.workspaceConnectionPoint;
    }

    private String getConnectionPointType() {
        return "workspace";
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.titleImage = IOUIPlugin.getImageDescriptor("/icons/full/wizban/workspace.png").createImage();
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (WorkspaceConnectionPropertyDialog.this.titleImage != null) {
                    WorkspaceConnectionPropertyDialog.this.setTitleImage(null);
                    WorkspaceConnectionPropertyDialog.this.titleImage.dispose();
                    WorkspaceConnectionPropertyDialog.this.titleImage = null;
                }
            }
        });
        this.setTitleImage(this.titleImage);
        if (this.workspaceConnectionPoint != null) {
            this.setTitle(Messages.WorkspaceConnectionPropertyDialog_EditTitle);
            this.getShell().setText(Messages.WorkspaceConnectionPropertyDialog_EditText);
        } else {
            this.setTitle(Messages.WorkspaceConnectionPropertyDialog_CreateTitle);
            this.getShell().setText(Messages.WorkspaceConnectionPropertyDialog_CreateText);
        }
        Composite container = new Composite(dialogArea, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).spacing(this.convertHorizontalDLUsToPixels(4), this.convertVerticalDLUsToPixels(4)).numColumns(3).create());
        Label label = new Label(container, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.WorkspaceConnectionPropertyDialog_ShortcutName));
        this.nameText = new Text(container, 2052);
        this.nameText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label = new Label(container, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.WorkspaceConnectionPropertyDialog_WorkspacePath));
        this.workspacePathText = new Text(container, 2052);
        this.workspacePathText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).create());
        this.workspacePathText.setEditable(false);
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(String.valueOf('&') + StringUtil.ellipsify((String)CoreStrings.BROWSE));
        this.browseButton.setLayoutData((Object)GridDataFactory.fillDefaults().hint(Math.max(new PixelConverter((Control)this.browseButton).convertHorizontalDLUsToPixels(61), this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        this.addListeners();
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceConnectionPropertyDialog.this.browseWorkspace();
            }
        });
        if (this.workspaceConnectionPoint == null) {
            try {
                this.workspaceConnectionPoint = (WorkspaceConnectionPoint)CoreIOPlugin.getConnectionPointManager().createConnectionPoint(this.getConnectionPointType());
                this.workspaceConnectionPoint.setName(DEFAULT_NAME);
                this.isNew = true;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)Messages.WorkspaceConnectionPropertyDialog_FailedToCreate, (Throwable)e);
                this.close();
            }
        }
        this.loadPropertiesFrom(this.workspaceConnectionPoint);
        return dialogArea;
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WorkspaceConnectionPropertyDialog.this.validate();
                }
            };
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.workspacePathText.addModifyListener(this.modifyListener);
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.nameText.removeModifyListener(this.modifyListener);
            this.workspacePathText.removeModifyListener(this.modifyListener);
        }
    }

    protected void okPressed() {
        if (!this.isValid()) {
            return;
        }
        if (this.savePropertiesTo(this.workspaceConnectionPoint)) {
            this.workspaceConnectionPoint.hashCode();
        }
        if (this.isNew) {
            CoreIOPlugin.getConnectionPointManager().addConnectionPoint((IConnectionPoint)this.workspaceConnectionPoint);
        }
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.validate();
        }
    }

    protected void loadPropertiesFrom(WorkspaceConnectionPoint connectionPoint) {
        this.removeListeners();
        try {
            this.nameText.setText(WorkspaceConnectionPropertyDialog.valueOrEmpty(connectionPoint.getName()));
            IContainer resource = connectionPoint.getResource();
            this.workspacePathText.setText(resource != null ? resource.getFullPath().toPortableString() : "");
        }
        finally {
            this.addListeners();
        }
    }

    protected boolean savePropertiesTo(WorkspaceConnectionPoint connectionPoint) {
        boolean updated = false;
        String name = this.nameText.getText();
        if (!name.equals(connectionPoint.getName())) {
            connectionPoint.setName(name);
            updated = true;
        }
        IPath path = Path.fromPortableString((String)this.workspacePathText.getText());
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource instanceof IContainer && !resource.equals((Object)connectionPoint.getResource())) {
            connectionPoint.setResource((IContainer)resource);
            updated = true;
        }
        return updated;
    }

    private void browseWorkspace() {
        IFileStore fileStore;
        FileFolderSelectionDialog dlg = new FileFolderSelectionDialog(this.getShell(), false, 2);
        IPath path = Path.fromPortableString((String)this.workspacePathText.getText());
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource instanceof IContainer) {
            dlg.setInitialSelection((Object)EFSUtils.getFileStore((IResource)resource));
        }
        dlg.setInput((Object)EFSUtils.getFileStore((IResource)ResourcesPlugin.getWorkspace().getRoot()));
        if (dlg.open() == 0 && (fileStore = (IFileStore)dlg.getFirstResult()) != null && (resource = (IResource)fileStore.getAdapter(IResource.class)) instanceof IContainer) {
            this.workspacePathText.setText(resource.getFullPath().toPortableString());
            if (DEFAULT_NAME.equals(this.nameText.getText())) {
                this.nameText.setText(resource.getName());
            }
        }
    }

    public void validate() {
        boolean valid = this.isValid();
        this.getButton(0).setEnabled(valid);
    }

    public boolean isValid() {
        String message = null;
        if (this.nameText.getText().length() == 0) {
            message = Messages.WorkspaceConnectionPropertyDialog_SpecifyShortcutName;
        } else {
            IPath path = Path.fromPortableString((String)this.workspacePathText.getText());
            IProject container = null;
            if (path.segmentCount() == 1) {
                container = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            } else if (path.segmentCount() > 1) {
                container = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            } else {
                message = Messages.WorkspaceConnectionPropertyDialog_SpecifyLocation;
            }
            if (!(message != null || container != null && container.exists())) {
                message = Messages.WorkspaceConnectionPropertyDialog_ResourceNotExist;
            }
        }
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage(message);
        return false;
    }

    protected static String valueOrEmpty(String value) {
        if (value != null) {
            return value;
        }
        return "";
    }
}

